<?php
class logged_stream
{
    private $stream;
    private $log_stream;
    private $bytes_read=0, $bytes_written=0;
    private $user;

function stream_open($path, $mode, $options, &$opened_path)
{
    static $modes = array(
        'r'=>'czytanie',
        'r+'=>'czytanie i zapisywanie',
        'w'=>'zapisywanie',
        'w+'=>'zapisywanie i czytanie',
        'a'=>'dopisywanie',
        'a+'=>'dopisywanie i czytanie',
        'x'=>'tworzenie i zapisywanie',
        'x+'=>'tworzenie, zapisywanie i czytanie');
    $path = substr($path, 9);
    $this->user = substr($path, 0, strpos($path, '@'));
    $path = substr($path, strpos($path, '@')+1);
    $this->stream = fopen($path, $mode, $options&STREAM_USE_PATH);
    $this->log_stream = fopen($path.'.log', 'a');
    if(!$this->log_stream)
    {
        if($options|STREAM_REPORT_ERRORS)
        {
            trigger_error('Dziennik strumienia: Nie mona otworzy pliku dziennika',
                          E_USER_WARNING);
        }
        return false;
    }
    if(!$this->stream)
    {
        if($options|STREAM_REPORT_ERRORS)
        {
            trigger_error('Dziennik strumienia: nie mona otworzy pliku '.$path,
                          E_USER_WARNING);
        }
        return false;
    }
    $binary = strpos($mode, 'b')!==false;
    if($binary)
        $mode = str_replace('b', '', $mode);
    list($micro, $sec) = explode(' ', microtime());
    $date = date('Y-m-d H:i:s').substr($micro, 1);
    fwrite($this->log_stream, 'Plik otwarty w trybie: '.$modes[$mode].
        ($binary?' W trybie binarnym przez ':' przez ').$this->user.' dnia '.$date."\n");
    return true;
}

function stream_close()
{
    fclose($this->stream);
    list($micro, $sec) = explode(' ', microtime());
    $date = date('Y-m-d H:i:s').substr($micro, 1);
    fwrite($this->log_stream, 'Plik zamknity przez '.$this->user.' dnia '.$date."\n");
    fwrite($this->log_stream, "Odczytano bajtw: ".$this->bytes_read."\n");
    fwrite($this->log_stream, "Zapisano bajtw: ".$this->bytes_written."\n");
    fwrite($this->log_stream, "\n");
    fclose($this->log_stream);
}
function stream_read($count)
{
    ob_start();
    debug_print_backtrace();
    $backtrace = ob_get_clean();
    fwrite($this->log_stream, $backtrace);
    $read = fread($this->stream, $count);
    $this->bytes_read+=strlen($read);
    return $read;
}
function stream_write($data)
{
    $read = fwrite($this->stream, $data);
    $this->bytes_written+=strlen($read);
    return $read;
}
function stream_eof()
{
    return feof($this->stream);
}
function stream_tell()
{
    return ftell($this->stream);
}
function stream_seek($offset, $whence=null)
{
    return fseek($this->stream, $offset, $whence);
}
function stream_flush()
{
    return true;
}
function stream_stat()
{
    return fstat($this->stream);
}
function unlink($path)
{
    $log_stream = fopen($path.'.log', 'a');
    if(!$log_stream)
    {
        trigger_error('Dziennik strumienia: Nie mona otworzy pliku dziennika. Plik nie zosta usunity.',
                      E_USER_WARNING);
        return false;
    }
    $success = unlink($path);
    list($micro, $sec) = explode(' ', microtime());
    $date = date('Y-m-d H:i:s').substr($micro, 1);
    if($success)
        fwrite($log_stream, "Plik $path zosta usunity dnia $date\n");
    else
        fwrite($log_stream, "Nie mona usun pliku $path, dnia $date\n");
    fclose($this->log_stream);
    return $success;
}
function rename($from_path, $to_path)
{
    $from_log_stream = fopen($from_path.'.log', 'a');
    $to_log_stream = fopen($to_path.'.log', 'a');
    if(!$from_log_stream || !$to_log_stream)
    {
        trigger_error('Dziennik strumienia: Nie mona otworzy pliku dziennika. Nie zmieniono nazwy pliku.',
                      E_USER_WARNING);
        return false;
    }
    $success = rename($from_path, $to_path);
    list($micro, $sec) = explode(' ', microtime());
    $date = date('Y-m-d H:i:s').substr($micro, 1);
    if($success)
    {
        fwrite($from_log_stream, "Nazwa pliku $from_path zostaa zmnieniona na $to_path dnia $date\n");
        fwrite($to_log_stream, "Plik $to_path przed chwil nazywa si $from_path dnia $date\n");
    }
    else
    {
        fwrite($from_log_stream, "Nie mona zmieni nazwy pliku $from_path na $to_path dnia
               $date\n");
        fwrite($to_log_stream, "Nie mona zmieni nazwy pliku $from_path na $to_path dnia
               $date\n");
    }
    fclose($from_log_stream);
    fclose($to_log_stream);
    return $success;
}

}
?>
